-- EpicForge Addon
-- Adds right-click options for copying character, guild links, and character compare links

EpicForge = {}
EpicForge.realm = GetRealmName()

StaticPopupDialogs["EPICFORGE_COPY_LINK"] = {
    text = "Copy & Paste the link into your browser",
    button1 = "Close",
    timeout = 0,
    whileDead = true,
    hideOnEscape = true,
    preferredIndex = 3,
    hasEditBox = true,
    OnShow = function(self, data)
        -- Simply populate the edit box with the link and highlight it
        self.editBox:SetText(data.url or "")
        self.editBox:HighlightText()
    end,
}

local function EpicForgeCharacterLinkButton(contextData)
    print("EpicForge: Copy Character Link button pressed")
    local realmSlug = GetRealmName():gsub("[%p%c]", ""):gsub("[%s]", "-"):lower()
    local url = string.format("https://epicforge.au/character/%s/%s", realmSlug, contextData.name:lower())
    StaticPopup_Show("EPICFORGE_COPY_LINK", "", "", { url = url })
end

local function EpicForgeGuildLinkButton(contextData)
    print("EpicForge: Copy Guild Link button pressed")
    local unit = contextData.unit or UIDROPDOWNMENU_INIT_MENU.unit or "target"
    local guildName = GetGuildInfo(unit)
    if not guildName then
        print("EpicForge: Player is not in a guild.")
        return
    end
    local realmSlug = GetRealmName():gsub("[%p%c]", ""):gsub("[%s]", "-"):lower()
    local formattedGuildName = guildName:lower():gsub(" ", "+")
    local url = string.format("https://epicforge.au/guild/%s/%s", realmSlug, formattedGuildName)
    StaticPopup_Show("EPICFORGE_COPY_LINK", "", "", { url = url })
end

local function EpicForgeCharCompareButton(contextData)
    print("EpicForge: Char Compare button pressed")
    local playerName = UnitName("player"):lower()
    local playerRealmSlug = GetRealmName():gsub("[%p%c]", ""):gsub("[%s]", "-"):lower()
    local selectedName = contextData.name:lower()
    -- Assuming the selected player is on the same realm as the player:
    local selectedRealmSlug = playerRealmSlug
    local url = string.format(
        "https://epicforge.au/char_compare.php?char1Name=%s&char1Realm=%s&char2Name=%s&char2Realm=%s",
        playerName, playerRealmSlug, selectedName, selectedRealmSlug
    )
    StaticPopup_Show("EPICFORGE_COPY_LINK", "", "", { url = url })
end

local menuTags = {
    "MENU_UNIT_SELF",
    "MENU_UNIT_PARTY",
    "MENU_UNIT_PLAYER",
    "MENU_UNIT_ENEMY_PLAYER",
    "MENU_UNIT_RAID_PLAYER",
    "MENU_UNIT_RAID",
    "MENU_UNIT_FRIEND",
    "MENU_UNIT_FRIEND_OFFLINE",
    "MENU_UNIT_BN_FRIEND",
    "MENU_UNIT_GUILD",
    "MENU_UNIT_GUILD_OFFLINE",
    "MENU_UNIT_CHAT_ROSTER",
    "MENU_UNIT_ARENAENEMY",
    "MENU_UNIT_FOCUS",
    "MENU_UNIT_COMMUNITIES_WOW_MEMBER",
    "MENU_UNIT_COMMUNITIES_GUILD_MEMBER",
    "MENU_UNIT_GUILDS_GUILD",
    "MENU_UNIT_COMMUNITIES_MEMBER",
    "MENU_UNIT_COMMUNITIES_COMMUNITY",
    "MENU_UNIT_RAID_TARGET_ICON",
    "MENU_UNIT_WORLD_STATE_SCORE",
    "MENU_UNIT_PVP_SCOREBOARD",
}

for _, tag in ipairs(menuTags) do
    Menu.ModifyMenu(tag, function(ownerRegion, rootDescription, contextData)
        rootDescription:CreateDivider()
        rootDescription:CreateButton("|cfff8b700Copy Character Link", function()
            EpicForgeCharacterLinkButton(contextData)
        end)
        rootDescription:CreateButton("|cfff8b700Copy Guild Link", function()
            EpicForgeGuildLinkButton(contextData)
        end)
        rootDescription:CreateButton("|cfff8b700Char Compare", function()
            EpicForgeCharCompareButton(contextData)
        end)
    end)
end
